import Map from 'ol/Map'
import View from 'ol/View'
import { fromLonLat } from 'ol/proj'
import { Tile as TileLayer } from 'ol/layer'
import { XYZ } from 'ol/source'

export default class Globals {
  id: string
  map: Map | null
  token: string

  constructor (id: string) {
    this.token = '72bba11e44f0c5c327edd4f680ce6871dcd60169b3fa6af30c29e1606bc21d23'
    this.id = id
    this.map = null
  }

  createMap() {
    this.map = new Map({
      target: this.id,
      layers: [
        // 底图
        new TileLayer({
          source: new XYZ({
            url: `https://tiles2.geovisearth.com/base/v1/img/{z}/{x}/{y}?format=webp&tmsIds=w&token=${this.token}`
          })
        }),
        // 注记
        new TileLayer({
          source: new XYZ({
            url: `https://tiles2.geovisearth.com/base/v1/cia/{z}/{x}/{y}?format=png&tmsIds=w&token=${this.token}`
          })
        }),
      ],
      view: new View({
          center: fromLonLat([113.53450137499999, 34.44104525]),
          zoom: 2
      })
    })
    
    // L.tileLayer().addTo(this.map)
    // L.tileLayer().addTo(this.map)
  }

  static initGlobals(id: string) {
    const global = new Globals(id)
    global.createMap()
    return global
  }
}
