import mapboxgl from 'mapbox-gl'
import 'mapbox-gl/dist/mapbox-gl.css'

export default class Globals {
  token: string 
  id: string
  map!: mapboxgl.Map

  constructor (id: string) {
    this.token = '72bba11e44f0c5c327edd4f680ce6871dcd60169b3fa6af30c29e1606bc21d23'
    this.id = id
  }

  createMap() {
    mapboxgl.accessToken = 'pk.eyJ1IjoibWFwYm94LWdsLWpzIiwiYSI6ImNram9ybGI1ajExYjQyeGxlemppb2pwYjIifQ.LGy5UGNIsXUZdYMvfYRiAQ'
  
    const geovisLayer = {
      "version": 8,
      'sources': {
        'geovis-tiles' : {
          type: 'raster',
          tiles: [`https://tiles2.geovisearth.com/base/v1/img/{z}/{x}/{y}?format=webp&tmsIds=w&token=${this.token}`],
          tileSize: 256
        }
      },
      'layers': [{
        id: 'geovis-layer',
        type: 'raster',
        source: 'geovis-tiles',
        minzoom: 0,
        maxzoom: 22
      }]
    }

    this.map = new mapboxgl.Map({
      container: 'map',
      center: [-74.5, 40],
      style: geovisLayer,
      zoom: 9,
    })
    const that = this
    this.map.on('load', function() {
      that.addRasterLayer(that.map, `https://tiles2.geovisearth.com/base/v1/cia/{z}/{x}/{y}?format=webp&tmsIds=w&token=${that.token}`, 'cialayer')
    })
  
  }

  addRasterLayer (map: mapboxgl.Map, url: string, layerid: string) {
    // 添加天地图影像底图
    map.addSource(layerid, {
      type: 'raster',
      tiles: [url],
      tileSize: 256
    })

    map.addLayer({
      id: layerid,
      type: 'raster',
      source: layerid,
      minzoom: 0,
      maxzoom: 18
    })
  } 

  addWindLayer () {
    const source = new TileSource('wind', {
        url: 'https://blog.sakitam.com/wind-layer/data/tiles/2023111700/2023111703/{z}/{x}/{y}/wind-surface.jpeg',
        tileSize: 256,
        minZoom: 0,
        maxZoom: 3,
        roundZoom: true,
        decodeType: DecodeType.imageWithExif,
        wrapX: true,
    })
  }

  static initGlobals(id: string) {
    const global = new Globals(id)
    global.createMap()
    return global
  }
}