import * as Cesium from 'cesium'

export default class Globals {
  token: string 
  id: string
  viewer!: Cesium.Viewer

  constructor (id: string) {
    this.token = '72bba11e44f0c5c327edd4f680ce6871dcd60169b3fa6af30c29e1606bc21d23'
    this.id = id
  }

  /**
    * 初始化球
 */
  createViewer () {
    Cesium.Ion.defaultAccessToken = 'eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJqdGkiOiIxYTAxZmI5OC1jMDYzLTRmOWMtYjM1ZC04MGQ2YzAwMGQzYWIiLCJpZCI6MTAzMDU0LCJpYXQiOjE2NTkxNjMxODl9.7UKJmNshNgOneyATKlT9IH3uyfS1BTGLx5-lXlvwSRU'

    this.viewer = new Cesium.Viewer(this.id, {
      baseLayerPicker: false,
      timeline: false,
      homeButton: false,
      fullscreenButton: false,
      infoBox: false,
      sceneModePicker: false,
      navigationInstructionsInitiallyVisible: false,
      navigationHelpButton: false,
      geocoder: false,
      animation: false,
      selectionIndicator: false,
      skyAtmosphere: false,
      orderIndependentTranslucency: false,
      contextOptions: {
        webgl: {
          alpha: true
        }
      },
      imageryProvider: new Cesium.UrlTemplateImageryProvider({
        url: `https://tiles{s}.geovisearth.com/base/v1/img/{z}/{x}/{y}?format=webp&token=${this.token}`,
        subdomains: '123'
      }),
      creditContainer: undefined,
      creditViewport: undefined,
      // 自定义天空盒
      skyBox: new Cesium.SkyBox({
        sources: {
          positiveX: '/assets/Textures/SkyBox/starmap_2020_16k_px.jpg',
          negativeX: '/assets/Textures/SkyBox/starmap_2020_16k_mx.jpg',
          positiveY: '/assets/Textures/SkyBox/starmap_2020_16k_py.jpg',
          negativeY: '/assets/Textures/SkyBox/starmap_2020_16k_my.jpg',
          positiveZ: '/assets/Textures/SkyBox/starmap_2020_16k_pz.jpg',
          negativeZ: '/assets/Textures/SkyBox/starmap_2020_16k_mz.jpg'
        }
      })
    })
    // 设置相机位置
    this.viewer.camera.setView({
      destination: Cesium.Cartesian3.fromDegrees(106, 30, 25000 * 1000)
    })
    // 开启抗锯齿
    this.viewer.scene.fxaa = true
    this.viewer.scene.postProcessStages.fxaa.enabled = true
    // 关闭地面大气
    this.viewer.scene.globe.showGroundAtmosphere = false
  }
 

  
  static initGlobals(id: string) {
    const global = new Globals(id)
    global.createViewer()
    return global
  }
}