import L from 'leaflet'

export default class Globals {
  id: string
  map: L.Map | null
  token: string

  constructor (id: string) {
    this.token = '72bba11e44f0c5c327edd4f680ce6871dcd60169b3fa6af30c29e1606bc21d23'
    this.id = id
    this.map = null
  }

  createMap() {
    this.map = L.map(this.id, {
      zoomControl: false,
      attributionControl: false,
      zoom: 3,
      minZoom: 3,
      maxZoom: 18
    }).setView([30, 110], 3)
    L.tileLayer(`https://tiles2.geovisearth.com/base/v1/img/{z}/{x}/{y}?format=webp&tmsIds=w&token=${this.token}`).addTo(this.map)
    L.tileLayer(`https://tiles2.geovisearth.com/base/v1/cia/{z}/{x}/{y}?format=png&tmsIds=w&token=${this.token}`).addTo(this.map)
  }

  static initGlobals(id: string) {
    const global = new Globals(id)
    global.createMap()
    return global
  }
}
