import { createMemoryHistory, createRouter } from 'vue-router'

const routes = [
  {
    name: 'leaflet',
    path: '/',
    redirect: '/leafletwind',
    children: [
      {
        name: 'leafletwind',
        path: '/leafletwind',
        component: () => import('@/views/leaflet/wind.vue')
      },
      {
        path: '/leafletcurrent',
        component: () => import('@/views/leaflet/current.vue')
      },
      {
        path: '/leafletocean',
        component: () => import('@/views/leaflet/ocean.vue')
      }
    ]
  },
  {
    path: '/cesium',
    children: [
      {
        path: '/cesiumwind',
        component: () => import('@/views/cesium/wind.vue')
      },
      {
        path: '/cesiumcurrent',
        component: () => import('@/views/cesium/current.vue')
      },
      {
        path: '/cesiumocean',
        component: () => import('@/views/cesium/ocean.vue')
      }
    ]
  },
  {
    path: '/amap',
    children: [
      {
        path: '/amapwind',
        component: () => import('@/views/amap/wind.vue')
      },
      {
        path: '/amapcurrent',
        component: () => import('@/views/amap/current.vue')
      },
      {
        path: '/amapocean',
        component: () => import('@/views/amap/ocean.vue')
      }
    ]
  },
  {
    path: '/bmap',
    children: [
      {
        path: '/bmapwind',
        component: () => import('@/views/bmap/wind.vue')
      },
      {
        path: '/bmapcurrent',
        component: () => import('@/views/bmap/current.vue')
      },
      {
        path: '/bmapocean',
        component: () => import('@/views/bmap/ocean.vue')
      }
    ]
  },
  {
    path: '/openlayer',
    children: [
      {
        path: '/openlayerwind',
        component: () => import('@/views/openlayer/wind.vue')
      },
      {
        path: '/openlayercurrent',
        component: () => import('@/views/openlayer/current.vue')
      },
      {
        path: '/openlayerocean',
        component: () => import('@/views/openlayer/ocean.vue')
      }
    ]
  }
]

const router = createRouter({
  history: createMemoryHistory(),
  routes,
})

export default router